<?php
echo "<pre>";

###################################
#
#   setting
#
###################################

//タイムアウト無制限
set_time_limit(0);

// メモリ上限引き上げ
ini_set("memory_limit", "512M");

// タイムゾーン
date_default_timezone_set('Asia/Tokyo');

require_once './config.php';

//「twitteroauth」読み込み
require_once '/home/bkycgpog/public_html/view001.xyz/2024_X_comment/vendor/autoload.php';    // フルパスで指定
use Abraham\TwitterOAuth\TwitterOAuth;

// echo $consumerKey;

// TwitterOAuthオブジェクト生成
$connection = new TwitterOAuth($consumerKey, $consumerSecret, $accessToken, $accessTokenSecret);
$connection->setApiVersion('2');

$username = "TkyoYuyabi3";

// エンドポイントを呼び出してユーザー情報を取得
$response = $connection->get('users/by/username/' . $username);

// ユーザーID（数値）を取得
if (isset($response->data)) {
    $uid = $response->data->id; // ユーザーID
    echo "ユーザーID: " . $uid . "\n";
} else {
    echo "エラー: " . json_encode($response) . "\n";
}


###################################
#
#   action
#
###################################

// ツイート取得    
$statuses = $connection->get(
    'tweets/search/recent',  
    [
        "query" => "from:$uid is:reply",
        "tweet.fields" => "id,created_at,conversation_id,entities,attachments",
        "user.fields" => "id,name,username",
        "max_results" => 10
    ]
); 

var_dump($statuses);

foreach( $statuses->data as $re ){
    $C_id = $re->entities->mentions[0]->username;
    $org_text = $re->text;
    $rp_id = $re->conversation_id;
    
    // メンション部分（@から始まる単語）を削除
    $org_text = preg_replace('/@\w+\s*/', '', $org_text);
    
    echo "CのID: ".$C_id."<br>";
    echo "リプライ文章: ".$org_text."<br>";
    echo "リプライID: ".$rp_id."<br>";
    echo "<br>";
    
    // リプライIDが既にDBに保管されているか突合
    
    // リプライ実行
    $parameters = [
        'text' => $org_text .PHP_EOL. " これは最高。",
        'reply' => ['in_reply_to_tweet_id' => $rp_id]
    ];
    $response = $connection->post('tweets', $parameters , true);
    echo "$response";
    break;
}